
package android.dev.base.life.transformer;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;

import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;


public class BindLifecycleSingleTransformer<T> implements SingleTransformer<T, T> {
    private final BehaviorProcessor<Lifecycle.Event> lifecycleBehavior;

    private BindLifecycleSingleTransformer() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public BindLifecycleSingleTransformer(@NonNull BehaviorProcessor<Lifecycle.Event> lifecycleBehavior) {
        this.lifecycleBehavior = lifecycleBehavior;
    }

    @Override
    public SingleSource<T> apply(Single<T> upstream) {
        return upstream.takeUntil(
                lifecycleBehavior.skipWhile(new Predicate<Lifecycle.Event>() {
                    @Override
                    public boolean test(Lifecycle.Event event) throws Exception {
                        return event != Lifecycle.Event.ON_DESTROY;
                    }
                })
        );
    }
}