
package android.dev.base.life.transformer;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;

import android.dev.base.life.LifecyclePublisher;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;


public class BindLifecycleMaybeTransformer<T> implements MaybeTransformer<T, T> {
    private final BehaviorProcessor<Lifecycle.Event> lifecycleBehavior;

    private BindLifecycleMaybeTransformer() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public BindLifecycleMaybeTransformer(@NonNull BehaviorProcessor<Lifecycle.Event> lifecycleBehavior) {
        this.lifecycleBehavior = lifecycleBehavior;
    }

    @Override
    public MaybeSource<T> apply(Maybe<T> upstream) {
        return upstream.takeUntil(
                lifecycleBehavior.skipWhile(new Predicate<Lifecycle.Event>() {
                    @Override
                    public boolean test(Lifecycle.Event event) throws Exception {
                        return event != Lifecycle.Event.ON_DESTROY;
                    }
                })
        );
    }
}