
package android.dev.base.life.transformer;

import android.arch.lifecycle.Lifecycle.Event;
import android.support.annotation.NonNull;

import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;


public class BindLifecycleCompletableTransformer<T> implements CompletableTransformer {
    private final BehaviorProcessor<Event> lifecycleBehavior;

    private BindLifecycleCompletableTransformer() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public BindLifecycleCompletableTransformer(@NonNull BehaviorProcessor<Event> lifecycleBehavior) {
        this.lifecycleBehavior = lifecycleBehavior;
    }

    @Override
    public CompletableSource apply(Completable upstream) {
        return upstream.ambWith(
                lifecycleBehavior.filter(new Predicate<Event>() {
                    @Override
                    public boolean test(Event event) throws Exception {
                        return event == Event.ON_DESTROY;
                    }
                }).take(1).flatMapCompletable(new Function<Event, Completable>() {
                    @Override
                    public Completable apply(Event flowable) throws Exception {
                        return Completable.complete();
                    }
                })
        );
    }
}