package android.dev.router;


import android.content.Context;
import android.support.v4.util.ArrayMap;

import java.lang.reflect.InvocationTargetException;

/**
 * Created by wbs on 2017/12/5 0005.
 */

public final class QueryBinder {

    static public class InstantiationException extends RuntimeException {
        public InstantiationException(String msg, Exception cause) {
            super(msg, cause);
        }
    }

    private static final ArrayMap<String, Class<?>> sInjectorClassMap =
            new ArrayMap<>();


    public static LinkQueryInjector findLinkInjector(Context context,String iName){
        try{
            Class<?> clazz = sInjectorClassMap.get(iName);
            if (clazz == null) {
                // Class not found in the cache, see if it's real, and try to add it
                clazz = context.getClassLoader().loadClass(iName);
                sInjectorClassMap.put(iName, clazz);
            }
            return (LinkQueryInjector) clazz.getConstructor().newInstance();
        }catch (ClassNotFoundException e) {
            throw new QueryBinder.InstantiationException("Unable to instantiate LinkQueryInjector " + iName
                    + ": make sure class name exists, is public, and has an"
                    + " empty constructor that is public", e);
        } catch (java.lang.InstantiationException e) {
            throw new QueryBinder.InstantiationException("Unable to instantiate LinkQueryInjector " + iName
                    + ": make sure class name exists, is public, and has an"
                    + " empty constructor that is public", e);
        } catch (IllegalAccessException e) {
            throw new QueryBinder.InstantiationException("Unable to instantiate LinkQueryInjector " + iName
                    + ": make sure class name exists, is public, and has an"
                    + " empty constructor that is public", e);
        } catch (NoSuchMethodException e) {
            throw new QueryBinder.InstantiationException("Unable to instantiate LinkQueryInjector " + iName
                    + ": could not find LinkQueryInjector constructor", e);
        } catch (InvocationTargetException e) {
            throw new QueryBinder.InstantiationException("Unable to instantiate LinkQueryInjector " + iName
                    + ": calling LinkQueryInjector constructor caused an exception", e);
        }
    }

}
