package android.dev.router;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by wbs on 2017/12/4 0004.
 */

public class PathLinker {

    final static String AUTHORITY_INNER = "android.dev.router";

    public static class AppLink {
        
        private final Uri.Builder mBuilder;

        private Bundle mBundle = null;

        private AppLink(String path){
            mBuilder = buildLink(path);
        }

        public AppLink with(String key,long value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,int value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,char value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,float value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,double value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,byte value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,short value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,boolean value){
            with(key,String.valueOf(value));
            return this;
        }

        public AppLink with(String key,String value){
            mBuilder.appendQueryParameter(key,value);
            return this;
        }
        public AppLink with(String key,Serializable value){
            ensureBundle();
            mBundle.putSerializable(key,value);
            return this;
        }

        public AppLink with(String key,String [] value){
            ensureBundle();
            mBundle.putStringArray(key,value);
            return this;
        }

        public AppLink with(String key,int [] value){
            ensureBundle();
            mBundle.putIntArray(key,value);
            return this;
        }

        public AppLink with(String key,boolean [] value){
            ensureBundle();
            mBundle.putBooleanArray(key,value);
            return this;
        }
        public AppLink with(String key,float [] value){
            ensureBundle();
            mBundle.putFloatArray(key,value);
            return this;
        }
        public AppLink with(String key,double [] value){
            ensureBundle();
            mBundle.putDoubleArray(key,value);
            return this;
        }
        public AppLink with(String key,char [] value){
            ensureBundle();
            mBundle.putCharArray(key,value);
            return this;
        }
        public AppLink with(String key,long [] value){
            ensureBundle();
            mBundle.putLongArray(key,value);
            return this;
        }

        public AppLink with(String key, ArrayList<String> val){
            ensureBundle();
            mBundle.putStringArrayList(key,val);
            return this;
        }

        public AppLink withParcelableArray(String key,ArrayList<? extends Parcelable> value ){
            ensureBundle();
            mBundle.putParcelableArrayList(key,value);
            return this;
        }

        public AppLink with(String key, Parcelable value){
            ensureBundle();
            mBundle.putParcelable(key,value);
            return this;
        }


        public AppLink host(String host){
            mBuilder.authority(host);
            return this;
        }
        private synchronized void ensureBundle(){
            if(mBundle==null){
                mBundle = new Bundle();
            }
        }

        public void go(Context context){
            Router.getDefault().enter(context,mBuilder.build(),mBundle);
        }

        public void goForResult(Context context,int requestCode){
            Router.getDefault().enter(context,mBuilder.build(),mBundle,requestCode);
        }
    }

    private static Uri.Builder buildLink(String path){
        String schema = Router.getDefault().getDefaultSchema();
        return new Uri.Builder()
                .scheme(schema)
                .authority(AUTHORITY_INNER)
                .path(path);
    }

    static AppLink getAppLink(String path){
        return new AppLink(path);
    }
}
