package android.dev.router;

import android.os.Bundle;

import java.util.List;

/**
 * Created by wbs on 2017/11/29 0029.
 */

public class Chain {

    private final List<RouterInterceptor> interceptors;

    private final int index;

    private int calls;

    public Chain(List<RouterInterceptor> interceptors, int index) {
        this.interceptors = interceptors;
        this.index = index;
    }

    public Channel proceed(Address address, Bundle bundle,int requestCode) throws AssertionError,RuntimeException {
        if (index >= interceptors.size()) {
            throw new AssertionError();
        }
        calls++;
        if (address == null) {
            throw new IllegalArgumentException("why address is null");
        }
        if (calls > 1) {
            throw new IllegalStateException("router interceptor " + interceptors.get(index - 1)
                    + " must call proceed() exactly once");
        }
        Chain next = new Chain(interceptors, index + 1);
        RouterInterceptor interceptor = interceptors.get(index);
        return interceptor.intercept(next, address, bundle,requestCode);
    }

    public void cancel() {

    }
}
