package android.dev.router;

import android.content.Context;
import android.net.Uri;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static android.dev.router.NamingPool.getTransformedHostName;

/**
 * Created by wbs on 2017/11/28 0028.
 */

public class AddressAuthenticator {

    private final Map<String,Bridge> mBridges = new HashMap<>();

    private final List<UriTransformer> mTransformers = new ArrayList<>();


    public void registerBridge(Bridge bridge) {
        if(bridge==null)
            return;
        mBridges.put(bridge.getHost(),bridge);
    }

    public Address getAddress(Uri uri) {
        String authority = uri.getAuthority();
        String path = uri.getPath();
        if(PathLinker.AUTHORITY_INNER.equals(authority)){
           for (Map.Entry<String,Bridge> entry:mBridges.entrySet()){
               Address address =entry.getValue().searchAddress(path);
               if(address!=null){
                   return address;
               }
           }
           return null;
        }else {
            Bridge table = mBridges.get(getTransformedHostName(authority));
            if (table == null) {
                return null;
            }

            return table.searchAddress(path);
        }

    }

    void addUriTransformer(UriTransformer uriTransformer){

        if(uriTransformer==null){
            return;
        }
        mTransformers.add(uriTransformer);
    }

    Uri performTransformUri(Context context,Uri uri){
        Uri mFinalUri = uri;
        for (UriTransformer transformer:mTransformers){
            mFinalUri = transformer.transform(context,mFinalUri);
            if(mFinalUri==null){
                throw new RuntimeException("uri responded can not be null,at {"+transformer.getClass().getName()+"}");
            }
        }
        return mFinalUri;
    }
}
