package android.dev.router;

/**
 * Created by wbs on 2017/12/6 0006.
 */

public final class NamingPool {

    private final static String PACKAGE_ROUTER_ROOT = "android.dev.apt.router";

    private final static String SUFFIX_INJECTOR = "$Injector";

    public static String getTransformedHostName(String userConfigHostName) {
        if (userConfigHostName == null)
            return "";


        return (userConfigHostName.replaceAll("\\.", "_") + "_Bridge$Impl").replaceAll("[^0-9a-zA-Z_]+", "");

    }

    public static String getBridgeQualifiedName(String userConfigHostName) {
        return PACKAGE_ROUTER_ROOT + "." + getTransformedHostName(userConfigHostName);
    }

    public static String getLinkQueryInjectorName(Object target) {
        Class<?> clazz = target.getClass();
        String clsName = clazz.getName();
        String packageName = clsName.substring(0, clsName.lastIndexOf("."));
        String targetClsName = clazz.getSimpleName() + SUFFIX_INJECTOR;
        return packageName + "." + targetClsName;
    }


}
