package android.dev.router;

/**
 * Created by wbs on 2018/4/12 0012.
 */

public class FlagCoder {

    public int mFlag;

    public String getFlagText() {
        return Integer.toOctalString(mFlag);
    }

    /**
     * @param reverseOrder 倒数第几位
     * @return 将flag转为八进制后的字符对应位数的值
     */
    public int getFlagCode(int reverseOrder) {
        String text = getFlagText();
        if (text == null) {
            return 0;
        }
        int index = text.length() - 1 - reverseOrder;
        if (index < 0) {
            return 0;
        }
        return text.charAt(index) - 48;
    }
}
