package android.dev.router;

import android.app.Activity;
import android.content.Context;

import static android.dev.router.Router.INVALIDATE_REQUEST_CODE;

/**
 * Created by wbs on 2017/11/30 0030.
 */

public class DefaultForwardTransformer implements ForwardTransformer {
    @Override
    public void forward(Channel channel,int requestCode) {
        Context context = channel.getContext();
        if(context instanceof Activity && requestCode!=INVALIDATE_REQUEST_CODE){
            Activity activity = (Activity) context;
            activity.startActivityForResult(channel.getForwardIntent(),requestCode);
        }else {
            context.startActivity(channel.getForwardIntent());
        }
    }

    @Override
    public boolean fit(Channel channel) {
        return true;
    }
}
