package android.dev.router;

import android.content.Context;
import android.content.Intent;

/**
 * Created by wbs on 2017/11/30 0030.
 */

public final class Channel extends FlagCoder {

    public final static int STATUS_ASYNC = Integer.MAX_VALUE;

    public final static int STATUS_OK = 1;

    private final Context mContext;

    private final Intent mIntent;

    private final String mActivityName;

    public final int mStatus;


    Channel(Context mContext, Intent mIntent, String mActivityName, int flag) {
        this.mContext = mContext;
        this.mIntent = mIntent;
        this.mActivityName = mActivityName;
        this.mStatus = STATUS_OK;
        mFlag = flag;
    }

    private Channel() {
        this.mContext = null;
        this.mIntent = null;
        this.mActivityName = null;
        this.mStatus = STATUS_ASYNC;
        mFlag = 0;
    }

    static Channel asyncChannel() {
        return new Channel();
    }

    public Context getContext() {
        return mContext;
    }

    public Intent getForwardIntent() {
        return mIntent;
    }

    public String getTargetActivityName() {
        return mActivityName;
    }

    void enter(Router router, int requestCode) {
        ForwardTransformer transformer = router.getTargetForwardTransformer(this);
        if (transformer == null) {
            throw new RuntimeException("why required transformer is null");
        }
        transformer.forward(this, requestCode);
    }
}
