package android.dev.router;

import android.os.Bundle;

/**
 * Created by wbs on 2017/12/1 0001.
 */

public abstract class AsyncProceedInterceptor implements RouterInterceptor {

    private int mRequestCode = Router.INVALIDATE_REQUEST_CODE;

    public void resumeProceed(Chain chain, Address address, Bundle bundle) {
        Channel channel = chain.proceed(address, bundle,mRequestCode);
        if (channel != null) {
           channel.enter(Router.getDefault(),mRequestCode);
        }
    }

    @Override
    public Channel intercept(Chain chain, Address address, Bundle bundle,final int requestCode) {
        if(shouldIntercept(address,bundle)){
            interceptAsync(chain, address, bundle);
            Channel channel = Channel.asyncChannel();
            this.mRequestCode = requestCode;
            return channel;
        }

        return chain.proceed(address,bundle,requestCode);
    }

    public abstract boolean shouldIntercept(Address address,Bundle bundle);

    public abstract void interceptAsync(Chain chain, Address address, Bundle bundle);
}
