package android.dev.router;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

/**
 * Created by wbs on 2017/11/30 0030.
 */

public class ForwardRouterInterceptor implements RouterInterceptor {

    private Context context;

    public ForwardRouterInterceptor(Context context) {
        this.context = context;
    }

    @Override
    public Channel intercept(Chain chain, Address address, Bundle bundle, int requestCode) {
        Intent intent = new Intent();
        ComponentName componentName= new ComponentName(context,address.mPathName);
        intent.setComponent(componentName);
        int type = Router.getDefault().queryLinkType(address);
        intent.putExtra(Router.KEY_LINK_TYPE, type);
        intent.putExtra(Router.KEY_FRAGMENT, address.mFragmentName);
        if (bundle != null)
            intent.putExtras(bundle);
        boolean outSideActivity = !(context instanceof Activity);
        if (outSideActivity) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        return new Channel(context, intent, address.mPathName);
    }
}
