package android.dev.router;

/**
 * Created by wbs on 2017/11/28 0028.
 */

public class Address {

    public String mHost;

    public String mLink;

    public int mType;

    public int mFlag;

    public String mPathName;

    public String mFragmentName;

    public String getFlagText() {
        return Integer.toOctalString(mFlag);
    }

    /**
     * @param reverseOrder 倒数第几位
     * @return 将flag转为八进制后的字符对应位数的值
     */
    public int getFlagCode(int reverseOrder) {
        String text = getFlagText();
        if (text == null) {
            return 0;
        }
        int index = text.length()-1-reverseOrder;
        if(index<0){
            return 0;
        }
        return text.charAt(index)-48;
    }

}
