package android.dev.base.support;

import android.os.Bundle;
import android.view.View;

/**
 * Created by wbs on 2017/12/19 0019.
 */

public final class FragmentCompat {

    public static FragmentViewHost newFragmentViewHost(boolean lifecycle) {
        if (lifecycle) {
            return new LifecycleFragmentViewHost();
        }
        return new UserActiveFragmentViewHost();
    }

    private static final class LifecycleFragmentViewHost implements FragmentViewHost {

        private View mView = null;

        @Override
        public void onPostCreateView(View createdView, Bundle bundle) {
            if (createdView != null) {
                mView = createdView.getRootView();
            }
        }

        @Override
        public void onPostViewCreated(View createView, Bundle bundle) {

        }

        @Override
        public void onPostDestroyView() {
            mView = null;
        }

        @Override
        public void onPostCallUserFirstShow() {

        }

        @Override
        public boolean isViewPreparedShouldCallUserFirstShow(boolean onVisibleHint) {
            return !onVisibleHint && mView != null;
        }

        @Override
        public boolean shouldInstanceFragmentView() {
            return true;
        }

        @Override
        public boolean shouldCreatedView() {
            return true;
        }

        @Override
        public View getHostView() {
            return mView;
        }
    }

    private static final class UserActiveFragmentViewHost implements FragmentViewHost {

        private View mView;

        private boolean mShouldInitView = false;

        private boolean mHasCalled = false;

        private boolean mViewPrepared = false;

        @Override
        public void onPostCreateView(View createdView, Bundle bundle) {
            mShouldInitView = createdView != null;
            if (createdView != null) {
                mView = createdView.getRootView();
            }
        }

        @Override
        public void onPostViewCreated(View createView, Bundle bundle) {
            mViewPrepared = true;
        }

        @Override
        public void onPostDestroyView() {
            mViewPrepared = false;
        }

        @Override
        public void onPostCallUserFirstShow() {
            mHasCalled = true;
        }

        @Override
        public boolean isViewPreparedShouldCallUserFirstShow(boolean onVisibleHint) {
            return mViewPrepared && !mHasCalled;
        }

        @Override
        public boolean shouldInstanceFragmentView() {
            return mShouldInitView;
        }

        @Override
        public boolean shouldCreatedView() {
            return mView == null;
        }

        @Override
        public View getHostView() {
            return mView;
        }
    }
}
