package android.dev.base.components;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.dev.base.api.container.CodeInjectContainer;
import android.dev.base.arch.Module;
import android.dev.base.arch.ModuleLoader;

import java.util.List;

/**
 * Created by wbs on 2018/4/18 0018.
 */

public final class MultiProcessLoader implements ProcessLoader, CodeInjectContainer<Module> {

    private final Application mApp;

    public MultiProcessLoader(Application app) {
        mApp = app;
    }

    private String mProcessName;

    @Override
    public void inject(Module module) {
        if (mProcessName == null || module.supportProcess(getContext(), mProcessName)) {
            module.setProcessName(mProcessName);
            ModuleLoader.getDefault().register(module);
        }
    }

    @Override
    public Context getContext() {
        return mApp;
    }

    @Override
    public void loadApplication() {
        Context context = getContext();
        mProcessName = AppMainLoader.isMainProcess() ? context.getPackageName() : getProcessName(context);
        loadMultiProcessModules();
    }


    private void loadMultiProcessModules() {

    }

    private String getProcessName(Context context) {
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        if (am != null) {
            int pid = android.os.Process.myPid();
            List<ActivityManager.RunningAppProcessInfo> processes = am.getRunningAppProcesses();
            if (processes != null) {
                for (ActivityManager.RunningAppProcessInfo process : processes) {
                    if (pid == process.pid) {
                        return process.processName;
                    }
                }
            }
        }
        return null;
    }

    public static void attach(Application app){
        new MultiProcessLoader(app).loadApplication();
    }
}
