package android.dev.base.components;

import android.dev.base.api.container.CodeInjectContainer;
import android.dev.base.arch.Module;
import android.dev.base.arch.ModuleLoader;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created by wbs on 2017/11/17 0017.
 */

public class AppMainLoader extends ApplicationLoader implements CodeInjectContainer<Module> {

    private final static AtomicBoolean isMainProcess = new AtomicBoolean(false);

    @Override
    public void loadApplication() {
        isMainProcess.set(true);
    }

    @Override
    public void inject(Module module) {
        ModuleLoader.getDefault().register(module);
    }

    public static boolean isMainProcess() {
        return isMainProcess.get();
    }
}
