package android.dev.base.components;

import android.app.Application;
import android.dev.base.arch.ActivityStack;
import android.dev.base.arch.AppContextLike;

/**
 * Created by wbs on 2017/11/17 0017.
 */


public class AppContext extends Application {

    public AppContext() {
        AppContextLike.getDefault().setApplication(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        AppContextLike.getDefault().onCreate(this);
    }

    @Override
    public void onTerminate() {
        AppContextLike.getDefault().onTerminate(this);
        super.onTerminate();
    }


    //------------------------------------------public api-------------------------
    public static AppContext getApp() {
        return AppContextLike.getAppContext();
    }

    public static ActivityStack activityStack() {
        return AppContextLike.getDefault().getActivityStack();
    }

    public static void appExit(boolean killProcess) {
        AppContextLike.getDefault().appExit(killProcess);
    }

}
