package android.dev.base.arch;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.dev.base.components.AppMainLoader;
import android.os.Process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Created by wbs on 2018/3/27 0027.
 */

public abstract class Module implements Pool<Component<Application>> {

    private String processName;


    private final List<Component<Application>> mComponents = new ArrayList<>();

    @Override
    public final void register(Component<Application> component) {
        if (component == null) {
            return;
        }
        mComponents.add(component);
    }

    @Override
    public final void unregister(Component<Application> component) {
        if (component == null) {
            return;
        }
        mComponents.remove(component);
    }

    @Override
    public final void clear() {
        mComponents.clear();
    }

    final void install(Application app) {
        onInstall(app);
        for (Component<Application> component : mComponents) {
            component.onCreate(app);
        }

    }

    final void uninstall(Application app) {
        onUninstall(app);
        for (Component<Application> component : mComponents) {
            component.onDestroy(app);
        }
    }

    public boolean supportProcess(Context context, String processName) {
        return context.getPackageName().equals(processName);
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public boolean isMainProcess() {
        return AppMainLoader.isMainProcess();
    }

    public int getPriority() {
        return 0;
    }

    public abstract String getName();

    protected abstract void onInstall(Application app);

    protected abstract void onUninstall(Application app);
}
