package android.dev.base.apiImpl;

import android.dev.base.api.container.MultiStateContainer;
import android.dev.base.api.injector.FragmentLayoutLayerInjector;
import android.dev.base.api.option.MultiStateConfigurator;
import android.dev.base.components.Faceplate;
import android.dev.base.pane.MultiStateLayout;
import android.support.v4.app.Fragment;
import android.view.View;

/**
 * Created by wbs on 2017/11/22 0022.
 */

public class MultiStateLayerInjectorFragmentImpl implements FragmentLayoutLayerInjector {
    @Override
    public void injectLayout(Faceplate bottle, Fragment fragment) {
        if(fragment instanceof MultiStateContainer){
            final MultiStateContainer container = (MultiStateContainer) fragment;
            Object target = container.getTarget();
            if(target==null){
                return;
            }
            if(target instanceof View){
                View mView = (View) target;
                MultiStateLayout layout;
                if(mView.getParent()==null){
                    layout = MultiStateLayout.newInstance(mView);
                }else {
                    layout = MultiStateLayout.attachToTarget(mView);
                }
                MultiStateConfigurator injector;
                if(fragment instanceof MultiStateConfigurator){
                    injector = (MultiStateConfigurator) fragment;
                }else {
                    injector = bottle.getMultiStateConfigurator();
                }
                if(injector==null){
                    throw new IllegalArgumentException("you must init MultiStateConfigurator at first or implements it");
                }
                injector.attachState(layout);
                MultiStateLayout.StateController controller =layout.compile();
                int [] states = layout.states();
                for (final int state:states){
                    controller.getStateTargetView(state).setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            container.onStatePerformClicked(v,state);
                        }
                    });
                }
                container.onRefTypeReturned(controller);
            }
        }
    }

}
