package android.dev.base.view;

import android.dev.base.R;
import android.dev.base.components.AppContext;
import android.widget.Toast;

/**
 * Created by wbs on 2017/11/20 0020.
 */

public final class GlobalToast {

    private static final Toast EMPTY_TOAST = Toast.makeText(AppContext.getApp(),
            R.string.emptyText,Toast.LENGTH_SHORT);

    public static Toast getToast(){
        return EMPTY_TOAST;
    }

    public static Toast ofToast(String msg) {
        EMPTY_TOAST.setText(msg);
        EMPTY_TOAST.show();
        return EMPTY_TOAST;
    }

    public static Toast closeToast() {
        EMPTY_TOAST.cancel();
        return EMPTY_TOAST;
    }

}
