package android.dev.base.utils;
import android.content.Context;
import android.content.res.Resources;
import android.util.TypedValue;

/**
 * 常用单位转换的辅助类
 * 
 * 
 * 
 */
public class UnitUtils
{
	private UnitUtils()
	{
		/* cannot be instantiated */
		throw new UnsupportedOperationException("cannot be instantiated");
	}

	/**
	 * dp转px
	 * 
	 * @param context
	 * @param dpVal
	 * @return the value of dip to pix
     * @deprecated use {@link #dp2px(float)} instead
	 */
	public static int dp2px(Context context, float dpVal)
	{
		return dp2px(dpVal);
	}

	public static int dp2px(float dpVal) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                dpVal, Resources.getSystem().getDisplayMetrics());
	}

	/**
	 * sp转px
	 *
	 * @param spVal
	 * @return the value of sp to px.
	 */
	public static int sp2px(float spVal)
	{
		return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP,
				spVal, Resources.getSystem().getDisplayMetrics());
	}

	/**
	 * px转dp
	 * 

	 * @param pxVal
	 * @return the value of px to dp.
	 */
	public static float px2dp(float pxVal)
	{
		final float scale =  Resources.getSystem().getDisplayMetrics().density;
		return (pxVal / scale);
	}

	/**
	 * px转sp
	 *
	 * @param pxVal
	 * @return the value of px to sp.
	 */
	public static float px2sp(float pxVal)
	{
		return (pxVal /  Resources.getSystem().getDisplayMetrics().scaledDensity);
	}

	 /**
     * 描述：ip地址转换为10进制数.
     *
     * @param ip the ip
     * @return the long
     */
    public static long ip2int(String ip){
    	ip = ip.replace(".", ",");
    	String[]items = ip.split(",");
    	return Long.valueOf(items[0])<<24 | Long.valueOf(items[1])<<16 | Long.valueOf(items[2])<<8 | Long.valueOf(items[3]);
    } 
    
    /**
	 * 字符串转整数
	 * @param str
	 * @param defValue
	 * @return
	 */
	public static int toInt(String str, int defValue) {
		try{
			return Integer.parseInt(str);
		}catch(Exception e){}
		return defValue;
	}
	
	/**
	 * 对象转整数
	 * @param obj
	 * @return 转换异常返回 0
	 */
	public static int toInt(Object obj) {
		if(obj==null) return 0;
		return toInt(obj.toString(),0);
	}
	/**
	 * String 转long 型 
	 * @param obj
	 * @return 转换异常返回 0
	 */
	public static long toLong(String obj) {
		try{
			return Long.parseLong(obj);
		}catch(Exception e){}
		return 0;
	}
	/**
	 * 字符串转布尔值
	 * @param b
	 * @return 转换异常返回 false
	 */
	public static boolean toBool(String b) {
		try{
			return Boolean.parseBoolean(b);
		}catch(Exception e){}
		return false;
	}
}
