package android.dev.base.support;

import android.dev.base.pane.MultiStateLayout;
import android.dev.base.pane.MultiStateLayout.StateController;
import android.view.View;

/**
 * Created by wbs on 2017/11/22 0022.
 */

public class AppNullOptions {

    private AppNullOptions(){
        throw new UnsupportedOperationException("can not instance class{"+getClass().getName()+"}");
    }
    private static class StateControllerHolder {
        private final static StateController IMPL = new StateController() {
            @Override
            public void showLoading(boolean animate) {

            }

            @Override
            public void showContent(boolean animate) {

            }

            @Override
            public void showEmpty(boolean animate) {

            }

            @Override
            public void showError(boolean animate) {

            }

            @Override
            public void showState(int state, boolean animate) {

            }

            @Override
            public void showState(int state, boolean coverMode, boolean animate) {

            }

            @Override
            public int getCurrentState() {
                return Integer.MIN_VALUE;
            }

            @Override
            public View getStateView(int state) {
                return null;
            }

            @Override
            public View getStateTargetView(int state) {
                return null;
            }
        };
    }

    public static StateController wrap(StateController controller){
        if(controller!=null){
            return controller;
        }
        return StateControllerHolder.IMPL;
    }

    public static StateController wrap(MultiStateLayout layout){
        if(layout!=null){
            return layout.compile();
        }
        return StateControllerHolder.IMPL;
    }
}
