package android.dev.base.apiImpl;

import android.app.Activity;
import android.dev.base.api.container.SwipeBackConfigurableContainer;
import android.dev.base.api.container.SwipeBackContainer;
import android.dev.base.api.injector.ActivityLayoutLayerInjector;
import android.dev.base.api.option.SwipeBackConfigurator;
import android.dev.base.components.Faceplate;

/**
 * Created by wbs on 2017/11/22 0022.
 */

public class SwipeBackLayerInjector implements ActivityLayoutLayerInjector {
    @Override
    public void injectLayout(Faceplate injector, Activity activity) {
        if(activity instanceof SwipeBackContainer){
            SwipeBackConfigurator configurator =injector.getSwipeBackConfigurator();
            if(configurator==null){
                return;
            }
            SwipeBackConfigurator.Configuration options = null;
            if(activity instanceof SwipeBackConfigurableContainer){
                options = ((SwipeBackConfigurableContainer) activity).configSwipeBackOptions();
            }
            configurator.attachSwipeBackLayout(activity,options);
        }
    }

}
