package android.dev.base.apiImpl;

import android.app.Activity;
import android.dev.base.api.container.MultiStateContainer;
import android.dev.base.api.injector.ActivityLayoutLayerInjector;
import android.dev.base.api.option.MultiStateConfigurator;
import android.dev.base.components.Faceplate;
import android.dev.base.pane.MultiStateLayout;
import android.view.View;

/**
 * Created by wbs on 2017/11/22 0022.
 */

public class MultiStateLayerInjectorActivityImpl implements ActivityLayoutLayerInjector {
    @Override
    public void injectLayout(Faceplate faceplate, Activity activity) {

        if(activity instanceof MultiStateContainer){
            final MultiStateContainer container = (MultiStateContainer) activity;
            Object target = container.getTarget();
            if(target==null){
                return;
            }
            MultiStateLayout layout;
            if(target == activity){
                layout = MultiStateLayout.attachToActivity(activity);
            }else if(target instanceof View) {
                layout = MultiStateLayout.attachToTarget((View) target);
            }else {
                return;
            }
            MultiStateConfigurator injector;
            if(activity instanceof MultiStateConfigurator){
                injector = (MultiStateConfigurator) activity;
            }else {
                injector = faceplate.getMultiStateConfigurator();
            }
            if(injector==null){
                throw new IllegalArgumentException("you must init MultiStateConfigurator at first or implements it");
            }
            injector.attachState(layout);
            MultiStateLayout.StateController controller =layout.compile();
            int [] states = layout.states();
            for (final int state:states){
                controller.getStateTargetView(state).setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        container.onStatePerformClicked(v,state);
                    }
                });
            }
            container.onRefTypeReturned(controller);
        }
    }
}
