package android.dev.base.api.option;

import android.app.Activity;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntDef;

/**
 * Created by wbs on 2017/11/22 0022.
 */

public interface SwipeBackConfigurator {

    int MODE_SIMPLE = 0;

    int MODE_PARALLAX = 1;

    @IntDef({MODE_PARALLAX,MODE_SIMPLE})
    @interface SwipeMode{}

    class Configuration{

        @SwipeMode
        public final int mode;

        public final float sensitivity;

        @ColorInt
        public final int scrimColor;

        public final float velocityThreshold;

        @FloatRange(from = .1f, to = .9f)
        public final float distanceThreshold;

        @FloatRange(from = 0f, to = 1f)
        public final float edgeSize;

        @FloatRange(from = 0.0, to = 1.0)
        public final float scrimStartAlpha;

        @FloatRange(from = 0.0, to = 1.0)
        public final float scrimEndAlpha;

        public Configuration(Builder builder){
            this.mode = builder.mode;
            this.sensitivity = builder.sensitivity;
            this.scrimColor = builder.scrimColor;
            this.velocityThreshold = builder.velocityThreshold;
            this.distanceThreshold = builder.distanceThreshold;
            this.edgeSize = builder.edgeSize;
            this.scrimStartAlpha = builder.scrimStartAlpha;
            this.scrimEndAlpha = builder.scrimEndAlpha;
        }

    }

    class Builder{
        @SwipeMode
        private int mode;

        private float sensitivity;

        @ColorInt
        private int scrimColor;

        private float velocityThreshold;

        @FloatRange(from = .1f, to = .9f)
        private float distanceThreshold;

        @FloatRange(from = 0f, to = 1f)
        private float edgeSize;

        @FloatRange(from = 0.0, to = 1.0)
        private float scrimStartAlpha;

        @FloatRange(from = 0.0, to = 1.0)
        private float scrimEndAlpha;

        public Builder sensitivity(float sensitivity) {
            this.sensitivity = sensitivity;
            return this;
        }

        public Builder scrimColor(@ColorInt int color) {
            this.scrimColor = color;
            return this;
        }

        public Builder velocityThreshold(float threshold) {
            this.velocityThreshold = threshold;
            return this;
        }

        public Builder distanceThreshold(@FloatRange(from = .1f, to = .9f) float threshold) {
            this.distanceThreshold = threshold;
            return this;
        }

        public Builder edgeSize(@FloatRange(from = 0f, to = 1f) float edgeSize) {
            this.edgeSize = edgeSize;
            return this;
        }

        public Builder scrimStartAlpha(@FloatRange(from = 0.0, to = 1.0) float alpha){
            this.scrimStartAlpha = alpha;
            return this;
        }

        public Builder scrimEndAlpha(@FloatRange(from = 0.0, to = 1.0) float alpha){
            this.scrimEndAlpha = alpha;
            return this;
        }

        public Configuration build(){
            return new Configuration(this);
        }

    }

    void attachSwipeBackLayout(Activity activity,Configuration option);
}
