package android.dev.base.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;

/**
 * Created by oeager on 2016/11/4.
 */

public final class ThemeUtils {

    private ThemeUtils(){
        throw new RuntimeException("Don't do this,boy");
    }

    public static int getThemeColorAttribute(Context context, @AttrRes int attr, int defaultColor){
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attr});
        int color = typedArray.getColor(0,defaultColor);
        typedArray.recycle();
        return color;
    }

    public static int getThemeReferenceAttribute(Context context, @AttrRes int attr, int defaultValue){
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attr});
        int resId = typedArray.getResourceId(0,defaultValue);
        typedArray.recycle();
        return resId;
    }
}
