package android.dev.base.components;

import android.app.Activity;
import android.app.Dialog;
import android.dev.base.api.ProgressDialogConstructor;
import android.dev.base.api.container.ActionBarContainer;
import android.dev.base.api.injector.ActionBarInjector;
import android.dev.base.api.injector.ActivityLayoutLayerInjector;
import android.dev.base.api.injector.FragmentLayoutLayerInjector;
import android.dev.base.api.injector.LayoutLayerInjector;
import android.dev.base.api.option.MultiStateConfigurator;
import android.dev.base.api.option.SwipeBackConfigurator;
import android.dev.base.apiImpl.MultiStateLayerInjectorActivityImpl;
import android.dev.base.apiImpl.MultiStateLayerInjectorFragmentImpl;
import android.dev.base.apiImpl.SwipeBackLayerInjector;
import android.dev.base.view.DefaultProgressDialog;
import android.support.v4.app.Fragment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by wbs on 2018/3/27 0027.
 */

public final class Faceplate {

    private static class _Holder {
        private final static Faceplate _IMPL = new Faceplate();
    }

    private Faceplate() {
        registerLayoutLayerInjector(new MultiStateLayerInjectorActivityImpl());
        registerLayoutLayerInjector(new SwipeBackLayerInjector());
        registerLayoutLayerInjector(new MultiStateLayerInjectorFragmentImpl());
    }

    public static Faceplate getDefault() {
        return _Holder._IMPL;
    }

    /**
     * inject layout layers
     */
    private final List<ActivityLayoutLayerInjector> mLayoutInjectors = new ArrayList<>();

    private final List<FragmentLayoutLayerInjector> mLayoutInjectors2 = new ArrayList<>();

    public void registerLayoutLayerInjector(LayoutLayerInjector injector) {
        if (injector instanceof ActivityLayoutLayerInjector) {
            synchronized (mLayoutInjectors) {
                mLayoutInjectors.add((ActivityLayoutLayerInjector) injector);
            }
        } else if (injector instanceof FragmentLayoutLayerInjector) {
            synchronized (mLayoutInjectors2) {
                mLayoutInjectors2.add((FragmentLayoutLayerInjector) injector);
            }
        }

    }

    public void unregisterLayoutLayersInjector(Class<? extends LayoutLayerInjector> cls) {

        synchronized (mLayoutInjectors) {
            Iterator<ActivityLayoutLayerInjector> iterator = mLayoutInjectors.iterator();
            while (iterator.hasNext()) {
                ActivityLayoutLayerInjector injector = iterator.next();
                if (injector.getClass().equals(cls)) {
                    iterator.remove();
                    return;
                }
            }
        }
        synchronized (mLayoutInjectors2) {
            Iterator<FragmentLayoutLayerInjector> iterator = mLayoutInjectors2.iterator();
            while (iterator.hasNext()) {
                FragmentLayoutLayerInjector injector = iterator.next();
                if (injector.getClass().equals(cls)) {
                    iterator.remove();
                    return;
                }
            }
        }


    }

    public void performInjectLayoutLayers(Activity activity) {
        synchronized (mLayoutInjectors) {
            for (ActivityLayoutLayerInjector injector : mLayoutInjectors) {
                injector.injectLayout(this, activity);
            }
        }
    }

    public void performInjectLayoutLayers(Fragment fragment) {
        synchronized (mLayoutInjectors2) {
            for (FragmentLayoutLayerInjector injector : mLayoutInjectors2) {
                injector.injectLayout(this, fragment);
            }
        }
    }

    /**
     * Inject ActionBar Container
     */
    private ActionBarInjector mActionBarInjector;

    public void registerActionBarInjector(ActionBarInjector injector) {
        this.mActionBarInjector = injector;
    }

    public void performInjectActionBarLayout(Activity activity) {
        if (mActionBarInjector == null) {
            return;
        }
        if (activity instanceof ActionBarContainer) {
            mActionBarInjector.injectActionBarLayout(activity);
        }
    }

    /**
     * ProgressDialog
     */
    private ProgressDialogConstructor mDialogConstructor;

    public Dialog createProgressDialog(Activity activity) {
        if (mDialogConstructor == null) {
            mDialogConstructor = new ProgressDialogConstructor() {
                @Override
                public Dialog construct(Activity activity) {
                    return new DefaultProgressDialog(activity);
                }
            };
        }
        return mDialogConstructor.construct(activity);
    }

    public void registProgressDialogConstructor(ProgressDialogConstructor constructor) {
        this.mDialogConstructor = constructor;
    }

    //---------------------App call to Inject---------------------------------

    private MultiStateConfigurator mMultiStateConfigurator;

    private SwipeBackConfigurator mSwipeBackConfigurator;

    public void registerMultiStateInjector(MultiStateConfigurator configurator) {
        mMultiStateConfigurator = configurator;
    }

    public void registerSwipeBackConfigurator(SwipeBackConfigurator configurator) {
        mSwipeBackConfigurator = configurator;
    }

    public MultiStateConfigurator getMultiStateConfigurator() {
        return mMultiStateConfigurator;
    }

    public SwipeBackConfigurator getSwipeBackConfigurator() {
        return mSwipeBackConfigurator;
    }
}
