package android.dev.base.components;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.support.annotation.Nullable;

import java.util.List;

/**
 * Created by wbs on 2018/1/11 0011.
 */

public abstract class AppShuntLoader extends ApplicationLoader {
    @Override
    public void loadApplication() {
        Context context = getContext();
        assert context != null;
        ActivityManager am = (ActivityManager)context.getSystemService(Context.ACTIVITY_SERVICE);
        if (am == null) {
            return;
        }
        int pid = android.os.Process.myPid();
        List<RunningAppProcessInfo> processes = am.getRunningAppProcesses();
        String processName = null;
        if (processes != null) {
            for(RunningAppProcessInfo process : processes) {
               if(pid==process.pid){
                   processName = process.processName;
                   break;
               }
            }
        }
        onLoadApp(processName);

    }

    protected abstract void onLoadApp(@Nullable String processName);
}
