package android.dev.base.components;

import android.app.Application;
import android.content.res.Configuration;
import android.dev.base.arch.ActivityStack;
import android.dev.base.arch.AppContextLike;

/**
 * Created by wbs on 2017/11/17 0017.
 */


public class AppContext extends Application {

    public AppContext() {
        AppContextLike.getDefault().setApplication(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        AppContextLike.getDefault().onCreate(this);
    }

    @Override
    public void onTerminate() {
        AppContextLike.getDefault().onTerminate(this);
        super.onTerminate();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppContextLike.getDefault().onConfigurationChanged(this, newConfig);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        AppContextLike.getDefault().onLowMemory(this);
    }

    @Override
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        AppContextLike.getDefault().onTrimMemory(this, level);
    }


    //------------------------------------------public api-------------------------
    public static AppContext getApp() {
        return AppContextLike.getAppContext();
    }

    public static ActivityStack activityStack() {
        return AppContextLike.getDefault().getActivityStack();
    }

    public static void appExit(boolean killProcess) {
        AppContextLike.getDefault().appExit(killProcess);
    }

}
