package android.dev.base.arch;

import android.app.Application;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wbs on 2018/3/27 0027.
 */

public abstract class Module implements Pool<Component<Application>> {

    private final List<Component<Application>> mComponents = new ArrayList<>();

    @Override
    public final void register(Component<Application> component) {
        if (component == null) {
            return;
        }
        if (component instanceof ApplicationComponent) {
            AppLifeComponents.getDefault().register((ApplicationComponent) component);
            return;
        }
        mComponents.add(component);
    }

    @Override
    public final void unregister(Component<Application> component) {
        if (component == null) {
            return;
        }
        if (component instanceof ApplicationComponent) {
            AppLifeComponents.getDefault().unregister((ApplicationComponent) component);
            return;
        }
        mComponents.remove(component);
    }

    @Override
    public final void clear() {
        mComponents.clear();
    }

    final void install(Application app) {
        onInstall(app);
        for (Component<Application> component:mComponents){
            component.onCreate(app);
        }

    }

    final void uninstall(Application app) {
        onUninstall(app);
        for (Component<Application> component:mComponents){
            component.onDestroy(app);
        }
    }

    public abstract String getName();

    protected abstract void onInstall(Application app);

    protected abstract void onUninstall(Application app);
}
