package android.dev.base.arch;

import android.app.Application;
import android.content.res.Configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wbs on 2018/3/27 0027.
 * used for manage all of the units of Component
 */

public final class AppLifeComponents implements Pool<ApplicationComponent> {

    private final static AppLifeComponents _INSTANCE = new AppLifeComponents();

    private AppLifeComponents() {

    }

    public static AppLifeComponents getDefault() {
        return _INSTANCE;
    }

    private final List<ApplicationComponent> mAppUnits = new ArrayList<>();

    public void performAppOnCreated(Application app) {
        for (ApplicationComponent deck : mAppUnits) {
            deck.onCreate(app);
        }
    }

    public void performAppTerminate(Application app) {
        for (ApplicationComponent deck : mAppUnits) {
            deck.onDestroy(app);
        }
    }

    public void performAppOnConfigurationChanged(Application app, Configuration newConfig) {
        for (ApplicationComponent deck : mAppUnits) {
            deck.onConfigurationChanged(app, newConfig);
        }
    }

    public void performOnLowMemory(Application application) {
        for (ApplicationComponent deck : mAppUnits) {
            deck.onLowMemory(application);
        }
    }

    public void performOnTrimMemory(Application application, int level) {
        for (ApplicationComponent deck : mAppUnits) {
            deck.onTrimMemory(application, level);
        }
    }

    @Override
    public void register(ApplicationComponent appUnit) {
        if (appUnit == null) {
            return;
        }
        mAppUnits.add(appUnit);
    }

    @Override
    public void unregister(ApplicationComponent appUnit) {
        if (appUnit == null) {
            return;
        }
        mAppUnits.remove(appUnit);
    }

    @Override
    public void clear() {
        mAppUnits.clear();
    }
}
