package android.dev.base.arch;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import java.util.Iterator;
import java.util.Stack;
import java.util.function.Consumer;

/**
 * Created by wbs on 2018/3/27 0027.
 */

public class ActivityStack implements Application.ActivityLifecycleCallbacks {

    private final Stack<Activity> activityStack = new Stack<>();

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        joinActivity(activity);
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {

    }

    @Override
    public void onActivityPaused(Activity activity) {

    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        popActivity(activity);
    }

    //------------------------------------------private method-----------------------
    private void joinActivity(Activity activity) {
        activityStack.add(activity);
    }

    private void popActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.remove(activity);
        }
    }

    //---------------------------------------package method---------------------

    public void popToActivity(Class<? extends Activity> cls) {
        while (true) {
            Activity activity = currentActivity();
            if (activity == null) {
                break;
            }
            if (activity.getClass().equals(cls)) {
                break;
            }
            finishActivity();
        }
    }

    public final void finishActivity() {
        if (activityStack.isEmpty()) {
            return;
        }
        Activity activity = activityStack.pop();
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
        }
    }

    public final void finishActivity(Activity activity) {
        if (activity != null) {
            this.activityStack.remove(activity);
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
    }

    public final void finishActivity(Class<? extends Activity> cls) {
        Iterator<Activity> iterator = activityStack.iterator();
        while (iterator.hasNext()) {
            Activity activity = iterator.next();
            if (activity.getClass().equals(cls)) {
                iterator.remove();
                if (!activity.isFinishing()) {
                    activity.finish();
                }
            }
        }
    }

    public final void finishAllActivity() {
        while (!activityStack.isEmpty()) {
            Activity activity = activityStack.pop();
            if (activity != null && !activity.isFinishing()) {
                activity.finish();
            }
        }
    }

    public final Activity getActivity(Class<? extends Activity> cls) {
        for (Activity activity : activityStack) {
            if (activity.getClass().equals(cls)) {
                return activity;
            }
        }
        return null;
    }

    public final Activity currentActivity() {
        if (activityStack.isEmpty()) {
            return null;
        }
        return activityStack.peek();
    }

    public final String dumpStackInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Activity activity : activityStack) {
            stringBuilder.append(activity.getClass().getName()).append("\n");
        }
        return stringBuilder.toString();
    }
}
