package android.dev.base.apiImpl;

import android.app.Activity;
import android.dev.base.api.injector.ActionBarInjector;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

/**
 * Created by wbs on 2017/11/23 0023.
 */

public abstract class AbstractActionBarInjectorImpl implements ActionBarInjector {
    @Override
    public void injectActionBarLayout(Activity activity) {
        ViewGroup mDecor = (ViewGroup) activity.getWindow().getDecorView();
        View mTemp = mDecor.getChildAt(0);
        LinearLayout mLayout = null;
        int mDecorChildCount = mDecor.getChildCount();
        if (mTemp instanceof LinearLayout) {
            mLayout = (LinearLayout) mTemp;
        } else if (mDecorChildCount > 1) {

            for (int i = 1; i < mDecorChildCount; i++) {
                mTemp = mDecor.getChildAt(i);
                if (mTemp instanceof LinearLayout) {
                    mLayout = (LinearLayout) mTemp;
                }
            }
            if (mLayout == null) {
                throw new UnsupportedOperationException("UnSupport this mode in current theme ");
            }
        } else {
            throw new UnsupportedOperationException("UnSupport this mode in current theme ");
        }

        View actionbar = LayoutInflater.from(activity).inflate(getDefaultActionBarLayout(activity), mLayout, false);
        mLayout.addView(actionbar, 0);
        afterInjectActionBar(activity,actionbar);

    }

    @LayoutRes
    protected abstract int getDefaultActionBarLayout(Activity activity);

    protected void afterInjectActionBar(Activity activity,View actionBar){

    }
}
