package android.dev.base.view;

import android.app.Dialog;
import android.content.Context;
import android.dev.base.R;
import android.dev.base.utils.ThemeUtils;
import android.dev.base.utils.UnitUtils;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.view.Gravity;
import android.widget.FrameLayout;

/**
 * Created by wbs on 2017/11/20 0020.
 */

public class DefaultProgressDialog extends Dialog{


    public DefaultProgressDialog(@NonNull Context context) {
        super(context, R.style.style_loading_dialog);
        FrameLayout frameLayout = new FrameLayout(context);
        int dp100 = UnitUtils.dp2px(100);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(dp100, dp100);
        params.gravity = Gravity.CENTER;
        frameLayout.setLayoutParams(params);

        DefaultLoadingView mLoadingView = new DefaultLoadingView(context);
        int dp80 = UnitUtils.dp2px(80);
        FrameLayout.LayoutParams loadingLayoutParam = new FrameLayout.LayoutParams(dp80,dp80);
        loadingLayoutParam.gravity= Gravity.CENTER;
        mLoadingView.setLayoutParams(loadingLayoutParam);

        frameLayout.addView(mLoadingView);

        int color = ThemeUtils.getThemeColorAttribute(context,R.attr.ProgressBarBackground,0x7f000000);
        GradientDrawable shapeDrawable = new GradientDrawable();
        shapeDrawable.setColor(color);
        shapeDrawable.setCornerRadius(UnitUtils.dp2px(8));
        ViewCompat.setBackground(frameLayout,shapeDrawable);
        setContentView(frameLayout);
    }

}
