package android.dev.base.support;

import android.app.Activity;
import android.dev.base.api.TypeRef;
import android.dev.base.components.ComponentsBox;
import android.dev.base.pane.MultiStateLayout.StateController;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/7 0007.
 */

public abstract class BaseFragment<RContext extends Activity> extends Fragment implements TypeRef<StateController> {

    private boolean mAttachForViewPager = false;

    private StateController mStateController;

    private RContext mContext;

    private FragmentViewHost mViewHost;

    //don't use getUserVisibleHint() of super method;
    private boolean mUserVisibleHint;

    public BaseFragment() {
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mContext = (RContext) getActivity();
        if (mViewHost == null) {
            mViewHost = FragmentCompat.newFragmentViewHost(!mAttachForViewPager);
        }
    }

    @Nullable
    @Override
    public final View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View mCreatedView = null;
        if (mViewHost.shouldCreatedView()) {
            mCreatedView = onCreateContentView(inflater, container, savedInstanceState);
            initComponents(mCreatedView, savedInstanceState);
            ComponentsBox.getDefault().performInjectLayoutLayers(this);
        }
        mViewHost.onPostCreateView(mCreatedView, savedInstanceState);
        return mViewHost.getHostView();
    }

    @Override
    public final void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mViewHost.onPostViewCreated(view, savedInstanceState);
        onPostCreated(savedInstanceState);
    }

    @Override
    public final void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (mViewHost.shouldInstanceFragmentView()) {
            initComponentsData(savedInstanceState);
        }
        if (!isAttachForViewPager()||(mUserVisibleHint && mViewHost.isViewPreparedShouldCallUserFirstShow(false))) {
            onShowToUserFirst();
            mViewHost.onPostCallUserFirstShow();
        }
    }

    @Override
    public final void onDestroyView() {
        mViewHost.onPostDestroyView();
        onPostDestroyed();
        super.onDestroyView();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        mUserVisibleHint = isVisibleToUser;
        if (!mUserVisibleHint) {
            return;
        }
        if (mViewHost == null) {
            return;
        }
        if (mViewHost.isViewPreparedShouldCallUserFirstShow(true)) {
            onShowToUserFirst();
            mViewHost.onPostCallUserFirstShow();
        }
    }

    @Override
    public final void onRefTypeReturned(StateController controller) {
        mStateController = AppNullOptions.wrap(controller);
    }

    protected void onPostCreated(Bundle bundle) {

    }

    protected void onPostDestroyed() {

    }

    public void onShowToUserFirst() {

    }

    public RContext getContext() {
        return mContext;
    }

    public boolean isAttachForViewPager() {
        return mAttachForViewPager;
    }

    public void setAttachForViewPager(boolean isAttachForViewPager) {
        this.mAttachForViewPager = isAttachForViewPager;
    }

    protected StateController getStateController() {
        return AppNullOptions.wrap(mStateController);
    }

    protected abstract View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle bundle);

    protected abstract void initComponents(View createView, Bundle savedInstanceState);

    protected abstract void initComponentsData(Bundle savedInstanceState);
}
