package android.dev.base.support;

import android.app.Dialog;
import android.dev.base.api.TypeRef;
import android.dev.base.components.ComponentsBox;
import android.dev.base.pane.MultiStateLayout.StateController;
import android.dev.base.view.GlobalToast;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;

/**
 * Created by wbs on 2017/11/16 0016.
 */

public abstract class BaseActivity extends AppCompatActivity implements TypeRef<StateController> {

    private Dialog mProgressDialog;

    private StateController mStateController;

    @Override
    protected final void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        onCreateActivity(savedInstanceState);
        ComponentsBox.getDefault().performInjectActionBarLayout(this);
        initTitleBar();
        initComponents();
        ComponentsBox.getDefault().performInjectLayoutLayers(this);
        initComponentsData();
    }

    protected abstract void onCreateActivity(@Nullable Bundle bundle);

    @Override
    public boolean onSupportNavigateUp() {
        onBackPressed();
        return true;
    }


    public void showProgressDialog(boolean cancelAble){
        if(mProgressDialog==null){
           mProgressDialog = ComponentsBox.getDefault().createProgressDialog(this);
        }
        mProgressDialog.setCancelable(cancelAble);
        if(mProgressDialog.isShowing()){
            return;
        }
        mProgressDialog.show();
    }

    public void dismissProgressDialog(){
        if(mProgressDialog==null){
            return;
        }
        if(mProgressDialog.isShowing()){
            mProgressDialog.dismiss();
        }
    }

    public void showToast(@StringRes int resId){
        showToast(getString(resId));
    }

    public void showToast(String msg){
        GlobalToast.ofToast(msg);
    }


    public abstract void initTitleBar();

    public abstract void initComponents();

    public abstract void initComponentsData();

    public StateController getStateController(){
        return AppNullOptions.wrap(mStateController);
    }


    @Override
    public final void onRefTypeReturned(StateController controller) {
        mStateController = controller;
    }

    @Override
    protected void onDestroy() {
        GlobalToast.closeToast();
        super.onDestroy();
    }
}
