package android.dev.base.components;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Bundle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by wbs on 2017/11/17 0017.
 */

public class AppMainLoader extends ApplicationLoader {

    private final static String FLAG_APP_DECK = "AppDeck";

    private final static String ASSETS_ROOT = "app_deck";

    @Override
    public void loadApplication() {
        Context context = getContext();
        List<AppDeck> decks = parseAnnotation(context);
        if(decks==null){
            decks = parseMetaData(context);
        }
        if (decks != null) {
            ComponentsBox injector = ComponentsBox.getDefault();
            for (AppDeck deck : decks) {
                injector.injectAppDeck(deck);
            }
        }
    }

    private static List<AppDeck> parseAnnotation(Context context) {
        AssetManager assetManager = context.getResources().getAssets();
        try {
            String[] list = assetManager.list(ASSETS_ROOT);
            if (list != null && list.length > 0) {
                List<AppDeck> decks = new ArrayList<>();
                for (String cls : list) {
                    AppDeck deck = trans2AppDeck(cls);
                    if(deck!=null){
                        decks.add(deck);
                    }
                }
                return decks;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List<AppDeck> parseMetaData(Context context) {
        List<AppDeck> modules = new ArrayList<>();
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(
                    context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            if (bundle == null) {
                return null;
            }
            String value = bundle.getString(FLAG_APP_DECK);
            if (value == null) {
                for (String key : bundle.keySet()) {
                    if (FLAG_APP_DECK.equals(bundle.get(key))) {
                        modules.add(trans2AppDeck(key));
                    }
                }
            } else {
                modules.add(trans2AppDeck(value));
            }

        } catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find metadata to parseMetaData AppDeck", e);
        }

        return modules;
    }

    private static AppDeck trans2AppDeck(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find AppDeck implementation", e);
        }

        Object module;
        try {
            module = clazz.newInstance();
        } catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate AppDeck implementation for " + clazz, e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate AppDeck implementation for " + clazz, e);
        }

        if (!(module instanceof AppDeck)) {
            throw new RuntimeException("Expected instanceof AppDeck, but found: " + module);
        }
        return (AppDeck) module;
    }
}
