package android.dev.base.components;

import android.app.Activity;
import android.app.Application;
import android.content.res.Configuration;
import android.support.annotation.Nullable;

/**
 * Created by wbs on 2017/11/17 0017.
 */


public class AppContext extends Application {

    public AppContext() {
        AppContextLike.getDefault().setApplication(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        AppContextLike.getDefault().onCreate(this);
    }

    @Override
    public void onTerminate() {
        AppContextLike.getDefault().onTerminate(this);
        super.onTerminate();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppContextLike.getDefault().onConfigurationChanged(this, newConfig);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        AppContextLike.getDefault().onLowMemory(this);
    }

    @Override
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        AppContextLike.getDefault().onTrimMemory(this, level);
    }


    //------------------------------------------public api-------------------------
    public static AppContext getApp() {
        return AppContextLike.getAppContext();
    }

    public static void finishActivity() {
        AppContextLike.getDefault().finishActivity();
    }

    public static void finishActivity(Activity activity) {
        AppContextLike.getDefault().finishActivity(activity);
    }

    public void finishActivity(Class<? extends Activity> cls) {
        AppContextLike.getDefault().finishActivity(cls);
    }

    public static void finishAllActivity() {
        AppContextLike.getDefault().finishAllActivity();
    }

    public static Activity getActivity(Class<? extends Activity> cls) {
        return AppContextLike.getDefault().getActivity(cls);
    }

    public static Activity currentActivity() {
        return AppContextLike.getDefault().currentActivity();
    }

    public static void appExit(boolean killProcess) {
       AppContextLike.getDefault().appExit(killProcess);
    }

    public static String dumpStackInfo() {
       return AppContextLike.getDefault().dumpStackInfo();
    }

    public static int getStackCount() {
        return AppContextLike.getDefault().getStackCount();
    }

    @Nullable
    public <A extends ApplicationDeck> A getAppDeck(Class<? extends ApplicationDeck> cls) {
        return ComponentsBox.getDefault().getAppDeck(cls);
    }

}
