/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import android.dev.annotation.Modular;
import android.dev.annotation.MultiModular;
import android.dev.compiler.BaseProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class ModularProcessor
extends BaseProcessor {
    @Override
    protected boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.log(">>>>>>>>>>>>>>start generate Module ");
        ArrayList<String> list = new ArrayList<String>();
        TypeMirror typeModule = this.mElements.getTypeElement("android.dev.base.arch.Module").asType();
        HashSet<Element> mElements = new HashSet<Element>();
        mElements.addAll(roundEnvironment.getElementsAnnotatedWith(Modular.class));
        mElements.addAll(roundEnvironment.getElementsAnnotatedWith(MultiModular.class));
        for (Element typeElement : mElements) {
            TypeMirror tm = typeElement.asType();
            String name = tm.toString();
            if (list.contains(name)) continue;
            if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("class [" + tm.toString() + "] used @Modular/@MultiModular,must be public class");
                return false;
            }
            if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.error("class [" + tm.toString() + "] used @Modular/@MultiModular,must not be abstract class");
                return false;
            }
            boolean hasPublicNoParameterConstructor = false;
            for (Element element : typeElement.getEnclosedElements()) {
                ExecutableElement constructorElement;
                if (element.getKind() != ElementKind.CONSTRUCTOR || (constructorElement = (ExecutableElement)element).getParameters().size() != 0 || !constructorElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                hasPublicNoParameterConstructor = true;
            }
            if (!hasPublicNoParameterConstructor) {
                this.error("class [" + tm.toString() + "] annotated @Modular/@MultiModular ,must provide an public empty default constructor");
                return false;
            }
            if (!this.mType.isSubtype(tm, typeModule)) continue;
            list.add(name);
            if (list.size() <= 1) continue;
            this.error("each module has and only one class is modified by @Modular/@MultiModular");
            return false;
        }
        list.clear();
        this.log(">>>>>>>>>>>>>>generate AppDeckNail end");
        return true;
    }

    @Override
    protected void putSupportAnnotations(Set<String> types) {
        types.add(Modular.class.getName());
        types.add(MultiModular.class.getName());
    }
}

