/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class BaseProcessor
extends AbstractProcessor {
    protected Filer mFiler;
    protected Elements mElements;
    protected Types mType;
    private Messager mMessager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFiler = processingEnvironment.getFiler();
        this.mElements = processingEnvironment.getElementUtils();
        this.mType = this.processingEnv.getTypeUtils();
        this.mMessager = processingEnvironment.getMessager();
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        this.putSupportAnnotations(set);
        return set;
    }

    public Messager getLogs() {
        return this.mMessager;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        return set != null && !set.isEmpty() && this.processing(set, roundEnvironment);
    }

    protected abstract boolean processing(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected abstract void putSupportAnnotations(Set<String> var1);

    protected void log(String log) {
        System.out.println(log);
    }

    protected void error(String error) {
        System.err.print(error);
        throw new RuntimeException();
    }
}

