package android.dev.compiler;


import android.dev.annotation.Modular;
import android.dev.annotation.MultiModular;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

/**
 * Created by wbs on 2017/11/17 0017.
 */
public class ModularProcessor extends BaseProcessor {

    @Override
    protected boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        log(">>>>>>>>>>>>>>start generate Module ");
        List<String> list = new ArrayList<>();
        TypeMirror typeModule = mElements.getTypeElement("android.dev.base.arch.Module").asType();
        Set<Element> mElements = new HashSet<>();
        mElements.addAll(roundEnvironment.getElementsAnnotatedWith(Modular.class));
        mElements.addAll(roundEnvironment.getElementsAnnotatedWith(MultiModular.class));
        for (Element typeElement : mElements) {
            TypeMirror tm = typeElement.asType();
            String name = tm.toString();
            if (list.contains(name)) {
                continue;
            }
            if (!typeElement.getModifiers().contains(Modifier.PUBLIC)) {
                error("class [" + tm.toString() + "] used @Modular/@MultiModular,must be public class");
                return false;
            }
            if (typeElement.getModifiers().contains(Modifier.ABSTRACT)) {
                error("class [" + tm.toString() + "] used @Modular/@MultiModular,must not be abstract class");
                return false;
            }

            boolean hasPublicNoParameterConstructor = false;
            for (Element enclosed : typeElement.getEnclosedElements()) {
                if (enclosed.getKind() == ElementKind.CONSTRUCTOR) {
                    ExecutableElement constructorElement = (ExecutableElement) enclosed;
                    if (constructorElement.getParameters().size() == 0 && constructorElement.getModifiers().contains(Modifier.PUBLIC)) {
                        hasPublicNoParameterConstructor = true;
                    }
                }
            }
            if (!hasPublicNoParameterConstructor) {
                error("class [" + tm.toString() + "] annotated @Modular/@MultiModular ,must provide an public empty default constructor");
                return false;
            }

            if (mType.isSubtype(tm, typeModule)) {
                list.add(name);
                if (list.size() > 1) {
                    error("each module has and only one class is modified by @Modular/@MultiModular");
                    return false;
                }
//                String path = ASSET_PATH + name;
//                try {
//                    FileObject f = mFiler.createResource(StandardLocation.CLASS_OUTPUT, "", path);
//                    f.openWriter().close();
////                    log("write appDeck name succeed :"+name);
//                } catch (IOException e) {
//                    e.printStackTrace();
////                    log("write appDeck name failed--------->");
//                }
            }

        }
        list.clear();
        log(">>>>>>>>>>>>>>generate AppDeckNail end");
        return true;
    }

    @Override
    protected void putSupportAnnotations(Set<String> types) {
        types.add(Modular.class.getName());
        types.add(MultiModular.class.getName());
    }


}
