package android.dev.compiler;


import java.util.List;

import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

/**
 * Created by wbs on 2017/12/6 0006.
 */

public class JavaTypePool {

    // Java type
    private static final String LANG = "java.lang";

    private static final String BYTE = LANG + ".Byte";

    private static final String SHORT = LANG + ".Short";

    private static final String INTEGER = LANG + ".Integer";

    private static final String LONG = LANG + ".Long";

    private static final String FLOAT = LANG + ".Float";

    private static final String DOUBLE = LANG + ".Double";

    private static final String BOOLEAN = LANG + ".Boolean";

    private static final String STRING = LANG + ".String";

    private static final String BOOLEAN_ARRAY = "boolean[]";

    private static final String INT_ARRAY = "int[]";

    private static final String LONG_ARRAY = "long[]";

    private static final String CHAR_ARRAY = "char[]";

    private static final String FLOAT_ARRAY ="float[]";

    private static final String DOUBLE_ARRAY ="double[]";

    private static final String STRING_ARRAY = LANG + ".String[]";

    private static final String ARRAY_LIST = "java.util.ArrayList";

    private static final String STRING_ARRAYLIST = ARRAY_LIST+"<"+STRING+">";

    private static final String CLASS_PATH_SERIALIZABLE = "java.io.Serializable";

    private static final String CLASS_PATH_PARCELABLE = "android.os.Parcelable";

    private final Types mTypes;

    private final Elements mElements;

    private final TypeMirror mTypeParcelableType;

    private final TypeMirror mTypeSerializableType;

    private Messager mLogs;

    public JavaTypePool(Types types,Elements elements,Messager msger){
        this.mTypes = types;
        this.mElements = elements;
        this.mLogs = msger;
        mTypeParcelableType = mElements.getTypeElement(CLASS_PATH_PARCELABLE).asType();
        mTypeSerializableType = mElements.getTypeElement(CLASS_PATH_SERIALIZABLE).asType();
    }

    public int getTypeOrdinal(Element element){
        TypeMirror typeMirror = element.asType();
        // Primitive
        if (typeMirror.getKind().isPrimitive()) {
            return element.asType().getKind().ordinal();
        }
        if(typeMirror instanceof DeclaredType) {
            if(typeMirror.toString().startsWith(ARRAY_LIST)||typeMirror.toString().startsWith("java.util.List")){
                DeclaredType type = (DeclaredType) typeMirror;
                List<? extends TypeMirror> argumentTypes = type.getTypeArguments();
                if(argumentTypes!=null&&!argumentTypes.isEmpty()){
                    TypeMirror argumentTp = argumentTypes.get(0);
                    if(argumentTp.toString().equals(STRING)){
                        return TypeKind.STRING_LIST.ordinal();
                    }
                    if(mTypes.isSubtype(argumentTp,mTypeParcelableType)){
                        return TypeKind.PARCELABLE_LIST.ordinal();
                    }
                }else {
                    return TypeKind.OBJECT.ordinal();
                }
            }
        }
        mLogs.printMessage(Diagnostic.Kind.NOTE,"find type--["+typeMirror.toString()+"] ");
        switch (typeMirror.toString()) {
            case BYTE:
                return TypeKind.BYTE.ordinal();
            case SHORT:
                return TypeKind.SHORT.ordinal();
            case INTEGER:
                return TypeKind.INT.ordinal();
            case LONG:
                return TypeKind.LONG.ordinal();
            case FLOAT:
                return TypeKind.FLOAT.ordinal();
            case DOUBLE:
                return TypeKind.DOUBLE.ordinal();
            case BOOLEAN:
                return TypeKind.BOOLEAN.ordinal();
            case STRING:
                return TypeKind.STRING.ordinal();
            case BOOLEAN_ARRAY:
                return TypeKind.BOOLEAN_ARRAY.ordinal();
            case INT_ARRAY:
                return TypeKind.INT_ARRAY.ordinal();
            case LONG_ARRAY:
                return TypeKind.LONG_ARRAY.ordinal();
            case CHAR_ARRAY:
                return TypeKind.CHAR_ARRAY.ordinal();
            case FLOAT_ARRAY:
                return TypeKind.FLOAT_ARRAY.ordinal();
            case DOUBLE_ARRAY:
                return TypeKind.DOUBLE_ARRAY.ordinal();
            case STRING_ARRAY:
                return TypeKind.STRING_ARRAY.ordinal();
            default:    // Other side, maybe the PARCELABLE or OBJECT.
                if(mTypes.isSubtype(typeMirror, mTypeParcelableType)){
                    return TypeKind.PARCELABLE.ordinal();
                }else if(mTypes.isSubtype(typeMirror, mTypeSerializableType)){
                    return TypeKind.SERIALIZABLE.ordinal();
                }else {
                    return TypeKind.OBJECT.ordinal();
                }
        }
    }
}
