package android.dev.compiler;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

/**
 * Created by wbs on 2017/12/5 0005.
 */

public abstract class BaseProcessor extends AbstractProcessor {

    protected Filer mFiler;

    protected Elements mElements;

    protected Types mType;

    private Messager mMessager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        mFiler = processingEnvironment.getFiler();
        mElements = processingEnvironment.getElementUtils();
        mType = processingEnv.getTypeUtils();
        mMessager = processingEnvironment.getMessager();
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        Set<String> set = new HashSet<>();
        putSupportAnnotations(set);
        return set;
    }

    public Messager getLogs() {
        return mMessager;
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        return !(set == null || set.isEmpty()) && processing(set, roundEnvironment);
    }

    protected abstract boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment);

    protected abstract void putSupportAnnotations(Set<String> types);

    protected void log(String log) {
//        mMessager.printMessage(Diagnostic.Kind.NOTE,log);
        System.out.println(log);
    }

    protected void error(String error) {
//        mMessager.printMessage(Diagnostic.Kind.ERROR,error);
        System.err.print(error);
        throw new RuntimeException();
    }


}
