/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import android.dev.annotation.Forward;
import android.dev.annotation.Link;
import android.dev.compiler.BaseProcessor;
import android.dev.compiler.RouterData;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedOptions(value={"host"})
public class RouterProcessor
extends BaseProcessor {
    private static final String APT_SOURCE_PKG = "android.dev.apt.router";
    private static final String ACTIVITY = "android.app.Activity";
    private static final String FRAGMENT = "android.app.Fragment";
    private static final String FRAGMENT_V4 = "android.support.v4.app.Fragment";
    private static final String JAVA_DOC = "@ automatically generated by Apt\n";
    private static final String CLASS_BRIDGE_PATH = "android.dev.router.Bridge";
    private String mHost;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Map<String, String> options = this.processingEnv.getOptions();
        if (options != null && !options.isEmpty()) {
            this.mHost = options.get("host");
        }
    }

    @Override
    public boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (this.mHost != null && this.mHost.length() > 0) {
            String[] pots = this.mHost.split("\\.");
            StringBuilder builder = new StringBuilder();
            for (String pot : pots) {
                builder.append(pot).append("_");
            }
            builder.append("Bridge$Impl");
            this.mHost = builder.toString().replaceAll("[^0-9a-zA-Z_]+", "");
            this.log("The user has configuration the mHost name, it was [" + this.mHost + "]");
        } else {
            this.error("These no mHost name, at 'build.gradle', like :\njavaCompileOptions {\n            annotationProcessorOptions {\n                arguments = [ host : 'your mHost name,may be use[project.getName()]' ]\n            }\n        }");
        }
        this.log("start generate Bridge Impl class:[" + this.mHost + "]");
        TypeMirror typeActivity = this.mElements.getTypeElement(ACTIVITY).asType();
        TypeMirror typeFragment = this.mElements.getTypeElement(FRAGMENT).asType();
        TypeMirror typeFragmentV4 = this.mElements.getTypeElement(FRAGMENT_V4).asType();
        TypeMirror typeBridge = this.mElements.getTypeElement(CLASS_BRIDGE_PATH).asType();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)this.mHost).addJavadoc(JAVA_DOC, new Object[0]).addSuperinterface(TypeName.get((TypeMirror)typeBridge)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        ClassName clsAddress = ClassName.get((String)"android.dev.router", (String)"Address", (String[])new String[0]);
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{TypeName.get(String.class), clsAddress});
        classBuilder.addField((TypeName)mapType, "mTable", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        classBuilder.addInitializerBlock(CodeBlock.builder().addStatement("mTable = new $T<>()", new Object[]{ClassName.get(HashMap.class)}).build());
        MethodSpec.Builder methodGetHost = MethodSpec.methodBuilder((String)"getHost").addAnnotation(Override.class).addJavadoc(JAVA_DOC, new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        methodGetHost.addStatement(" return $S", new Object[]{this.mHost});
        classBuilder.addMethod(methodGetHost.build());
        MethodSpec.Builder methodSearchAddress = MethodSpec.methodBuilder((String)"searchAddress").addJavadoc(JAVA_DOC, new Object[0]).addAnnotation(Override.class).addParameter(String.class, "path", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)clsAddress);
        methodSearchAddress.addStatement("return mTable.get(path)", new Object[0]);
        classBuilder.addMethod(methodSearchAddress.build());
        MethodSpec.Builder methodGenerateSpaceAddress = MethodSpec.methodBuilder((String)"generateSpaceAddress").addJavadoc(JAVA_DOC, new Object[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns((TypeName)clsAddress);
        methodGenerateSpaceAddress.addStatement("$T address = new $T()", new Object[]{clsAddress, clsAddress});
        methodGenerateSpaceAddress.addStatement("address.mHost = getHost()", new Object[0]);
        methodGenerateSpaceAddress.addStatement("return address", new Object[0]);
        classBuilder.addMethod(methodGenerateSpaceAddress.build());
        ArrayList<RouterData> mData = new ArrayList<RouterData>();
        for (TypeElement typeElement : ElementFilter.typesIn(roundEnvironment.getElementsAnnotatedWith(Link.class))) {
            TypeElement activityElement;
            String name;
            TypeMirror tm = typeElement.asType();
            Link link = typeElement.getAnnotation(Link.class);
            RouterData router = new RouterData();
            String value = link.value();
            if (!value.startsWith("/")) {
                this.error("link means the path of the uri,must start with '/' ->[" + value + "]");
            }
            router.value = link.value();
            router.flag = link.flag();
            Forward forward = typeElement.getAnnotation(Forward.class);
            if (this.mType.isSubtype(tm, typeActivity)) {
                router.mType = 0;
                router.mActivityElement = typeElement.getQualifiedName().toString();
                router.mFragmentElement = null;
            } else if (this.mType.isSubtype(tm, typeFragment)) {
                router.mType = 1;
                router.mFragmentElement = typeElement;
                if (forward == null) {
                    this.error("Fragment annotated @Link,must annotated @Forward to set the Activity");
                    return false;
                }
                name = forward.name();
                if (name.length() > 0) {
                    router.mActivityElement = name;
                } else {
                    activityElement = this.getAnnotationClassElement(forward);
                    if (!this.mType.isSubtype(activityElement.asType(), typeActivity)) {
                        this.error("Fragment annotated @Forward,must be a subclass of Activity");
                    }
                    router.mActivityElement = activityElement.getQualifiedName().toString();
                }
            } else if (this.mType.isSubtype(tm, typeFragmentV4)) {
                router.mType = 2;
                router.mFragmentElement = typeElement;
                if (forward == null) {
                    this.error("Fragment annotated @Link,must annotated @Forward to set the Activity");
                    return false;
                }
                name = forward.name();
                if (name.length() > 0) {
                    router.mActivityElement = name;
                } else {
                    activityElement = this.getAnnotationClassElement(forward);
                    if (!this.mType.isSubtype(activityElement.asType(), typeActivity)) {
                        this.error("Fragment annotated @Forward,must be a subclass of Activity");
                    }
                    router.mActivityElement = activityElement.getQualifiedName().toString();
                }
            } else {
                this.error("Annotation [Link] only used for class activity or fragment,but you used for:" + tm.toString());
            }
            mData.add(router);
        }
        MethodSpec.Builder constructorMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder constructCode = CodeBlock.builder();
        if (mData.size() > 0) {
            RouterData data = (RouterData)mData.get(0);
            constructCode.addStatement("$T address = generateSpaceAddress()", new Object[]{clsAddress});
            this.addRouterStatement(constructCode, data);
        }
        if (mData.size() > 1) {
            for (int i = 1; i < mData.size(); ++i) {
                RouterData data = (RouterData)mData.get(i);
                constructCode.addStatement("address = generateSpaceAddress()", new Object[0]);
                this.addRouterStatement(constructCode, data);
            }
        }
        constructorMethod.addCode(constructCode.build());
        classBuilder.addMethod(constructorMethod.build());
        JavaFile javaFile = JavaFile.builder((String)APT_SOURCE_PKG, (TypeSpec)classBuilder.build()).build();
        try {
            javaFile.writeTo(this.mFiler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    protected void putSupportAnnotations(Set<String> types) {
        types.add(Link.class.getName());
        types.add(Forward.class.getName());
    }

    private void addRouterStatement(CodeBlock.Builder codeBuilder, RouterData routerData) {
        codeBuilder.addStatement("address.mPathName = $S", new Object[]{routerData.mActivityElement});
        String value = routerData.value;
        codeBuilder.addStatement("address.mLink = $S", new Object[]{value});
        codeBuilder.addStatement("address.mFlag = $L", new Object[]{routerData.flag});
        codeBuilder.addStatement("address.mType = $L", new Object[]{routerData.mType});
        if (routerData.mType == 2) {
            codeBuilder.addStatement("address.mFragmentName = $T.class.getName()", new Object[]{routerData.mFragmentElement});
        } else if (routerData.mType == 1) {
            codeBuilder.addStatement("address.mFragmentName = $T.class.getName()", new Object[]{routerData.mFragmentElement});
        }
        if (value != null && value.length() > 0) {
            codeBuilder.addStatement("mTable.put($S,address)", new Object[]{value});
        } else {
            this.error("why path is null for:" + value);
        }
        codeBuilder.add("//---------------------------\n", new Object[0]);
    }

    private TypeElement getAnnotationClassElement(Forward forward) {
        String name;
        try {
            Class clazz = forward.value();
            name = clazz.getCanonicalName();
        }
        catch (MirroredTypeException e) {
            DeclaredType type = (DeclaredType)e.getTypeMirror();
            TypeElement element = (TypeElement)type.asElement();
            name = element.getQualifiedName().toString();
        }
        return this.mElements.getTypeElement(name);
    }
}

