/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import android.dev.annotation.LinkQuery;
import android.dev.compiler.BaseProcessor;
import android.dev.compiler.JavaTypePool;
import android.dev.compiler.TypeKind;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class LinkQueryProcessor
extends BaseProcessor {
    private static final String ACTIVITY = "android.app.Activity";
    private static final String FRAGMENT = "android.app.Fragment";
    private static final String FRAGMENT_V4 = "android.support.v4.app.Fragment";
    private static final String LINK_QUERY_INJECTOR = "android.dev.router.LinkQueryInjector";
    private static final String JAVA_DOC = "@ automatically generated by Apt\n";
    private static final String SUFFIX_INJECTOR = "$Injector";

    @Override
    protected boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.log("start process LinkQuery Annotations");
        Set<? extends Element> elementSet = roundEnvironment.getElementsAnnotatedWith(LinkQuery.class);
        HashMap<TypeElement, ArrayList<Element>> parentAndChild = new HashMap<TypeElement, ArrayList<Element>>();
        for (Element element : elementSet) {
            ArrayList<Element> mElements;
            TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("The inject fields CAN NOT BE 'private'!!! please check field [" + element.getSimpleName() + "] in class [" + enclosingElement.getQualifiedName() + "]");
            }
            if ((mElements = (ArrayList<Element>)parentAndChild.get(enclosingElement)) == null) {
                mElements = new ArrayList<Element>();
                parentAndChild.put(enclosingElement, mElements);
            }
            mElements.add(element);
        }
        if (!parentAndChild.isEmpty()) {
            TypeMirror typeActivity = this.mElements.getTypeElement(ACTIVITY).asType();
            TypeMirror typeMirror = this.mElements.getTypeElement(FRAGMENT).asType();
            TypeMirror typeFragmentV4 = this.mElements.getTypeElement(FRAGMENT_V4).asType();
            TypeMirror typeInjector = this.mElements.getTypeElement(LINK_QUERY_INJECTOR).asType();
            ParameterSpec objectParamSpec = ParameterSpec.builder((TypeName)TypeName.OBJECT, (String)"target", (Modifier[])new Modifier[0]).build();
            for (Map.Entry entry : parentAndChild.entrySet()) {
                boolean isActivity;
                TypeElement parent = (TypeElement)entry.getKey();
                List children = (List)entry.getValue();
                String qualifiedName = parent.getQualifiedName().toString();
                String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                String fileName = parent.getSimpleName() + SUFFIX_INJECTOR;
                TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)fileName).addJavadoc(JAVA_DOC, new Object[0]).addSuperinterface(ClassName.get((TypeMirror)typeInjector)).addModifiers(new Modifier[]{Modifier.PUBLIC});
                MethodSpec.Builder methodInject = MethodSpec.methodBuilder((String)"inject").addAnnotation(Override.class).addJavadoc(JAVA_DOC, new Object[0]).addParameter(objectParamSpec).addModifiers(new Modifier[]{Modifier.PUBLIC});
                methodInject.addStatement("$T _target = ($T)target", new Object[]{ClassName.get((TypeElement)parent), ClassName.get((TypeElement)parent)});
                ClassName queryParserClazz = ClassName.get((String)"android.dev.router", (String)"QueryParser", (String[])new String[0]);
                TypeMirror parentType = parent.asType();
                if (this.mType.isSubtype(parentType, typeActivity)) {
                    methodInject.addStatement("$T data = _target.getIntent()", new Object[]{ClassName.get((String)"android.content", (String)"Intent", (String[])new String[0])});
                    isActivity = true;
                } else if (this.mType.isSubtype(parentType, typeMirror) || this.mType.isSubtype(parentType, typeFragmentV4)) {
                    methodInject.addStatement("$T data = _target.getArguments()", new Object[]{ClassName.get((String)"android.os", (String)"Bundle", (String[])new String[0])});
                    isActivity = false;
                } else {
                    return false;
                }
                JavaTypePool javaTypePool = new JavaTypePool(this.mType, this.mElements, this.getLogs());
                for (Element element : children) {
                    String formatText;
                    LinkQuery query = element.getAnnotation(LinkQuery.class);
                    String fieldName = element.getSimpleName().toString();
                    int type = javaTypePool.getTypeOrdinal(element);
                    String key = query.value();
                    if (type == TypeKind.BOOLEAN.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseBoolean(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.BYTE.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseByte(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.SHORT.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseShort(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.INT.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseInt(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.LONG.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseLong(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.CHAR.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseChar(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.FLOAT.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseFloat(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.DOUBLE.ordinal()) {
                        methodInject.addStatement("_target.$L = $T.parseDouble(" + this.getFormatExtraGetter(isActivity) + ")", new Object[]{fieldName, queryParserClazz, key});
                        continue;
                    }
                    if (type == TypeKind.STRING.ordinal()) {
                        methodInject.addStatement("_target.$L = " + this.getFormatExtraGetter(isActivity), new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.BOOLEAN_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getBooleanArrayExtra($S)" : "_target.$L = data.getBooleanArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.INT_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getIntArrayExtra($S)" : "_target.$L = data.getIntArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.LONG_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getLongArrayExtra($S)" : "_target.$L = data.getLongArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.CHAR_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getCharArrayExtra($S)" : "_target.$L = data.getCharArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.FLOAT_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getFloatArrayExtra($S)" : "_target.$L = data.getFloatArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.DOUBLE_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getDoubleArrayExtra($S)" : "_target.$L = data.getDoubleArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.STRING_ARRAY.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getStringArrayExtra($S)" : "_target.$L = data.getStringArray($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.STRING_LIST.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getStringArrayListExtra($S)" : "_target.$L = data.getStringArrayList($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.PARCELABLE_LIST.ordinal()) {
                        formatText = isActivity ? "_target.$L = data.getParcelableArrayListExtra($S)" : "_target.$L = data.getParcelableArrayList($S)";
                        methodInject.addStatement(formatText, new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.PARCELABLE.ordinal()) {
                        if (isActivity) {
                            methodInject.addStatement("_target.$L = data.getParcelableExtra($S)", new Object[]{fieldName, key});
                            continue;
                        }
                        methodInject.addStatement("_target.$L = data.getParcelable($S)", new Object[]{fieldName, key});
                        continue;
                    }
                    if (type == TypeKind.SERIALIZABLE.ordinal()) {
                        if (isActivity) {
                            methodInject.addStatement("_target.$L = ($T) data.getSerializableExtra($S)", new Object[]{fieldName, ClassName.get((TypeMirror)element.asType()), key});
                            continue;
                        }
                        methodInject.addStatement("_target.$L = ($T) data.getSerializable($S)", new Object[]{fieldName, ClassName.get((TypeMirror)element.asType()), key});
                        continue;
                    }
                    if (type != TypeKind.OBJECT.ordinal()) continue;
                }
                classBuilder.addMethod(methodInject.build());
                try {
                    JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build().writeTo(this.mFiler);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private String getFormatExtraGetter(boolean isActivity) {
        return isActivity ? "data.getStringExtra($S)" : "data.getString($S)";
    }

    @Override
    protected void putSupportAnnotations(Set<String> types) {
        types.add(LinkQuery.class.getName());
    }
}

