/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import android.dev.compiler.TypeKind;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class JavaTypePool {
    private static final String LANG = "java.lang";
    private static final String BYTE = "java.lang.Byte";
    private static final String SHORT = "java.lang.Short";
    private static final String INTEGER = "java.lang.Integer";
    private static final String LONG = "java.lang.Long";
    private static final String FLOAT = "java.lang.Float";
    private static final String DOUBLE = "java.lang.Double";
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final String STRING = "java.lang.String";
    private static final String BOOLEAN_ARRAY = "boolean[]";
    private static final String INT_ARRAY = "int[]";
    private static final String LONG_ARRAY = "long[]";
    private static final String CHAR_ARRAY = "char[]";
    private static final String FLOAT_ARRAY = "float[]";
    private static final String DOUBLE_ARRAY = "double[]";
    private static final String STRING_ARRAY = "java.lang.String[]";
    private static final String ARRAY_LIST = "java.util.ArrayList";
    private static final String STRING_ARRAYLIST = "java.util.ArrayList<java.lang.String>";
    private static final String CLASS_PATH_SERIALIZABLE = "java.io.Serializable";
    private static final String CLASS_PATH_PARCELABLE = "android.os.Parcelable";
    private final Types mTypes;
    private final Elements mElements;
    private final TypeMirror mTypeParcelableType;
    private final TypeMirror mTypeSerializableType;
    private Messager mLogs;

    public JavaTypePool(Types types, Elements elements, Messager msger) {
        this.mTypes = types;
        this.mElements = elements;
        this.mLogs = msger;
        this.mTypeParcelableType = this.mElements.getTypeElement(CLASS_PATH_PARCELABLE).asType();
        this.mTypeSerializableType = this.mElements.getTypeElement(CLASS_PATH_SERIALIZABLE).asType();
    }

    public int getTypeOrdinal(Element element) {
        TypeMirror typeMirror = element.asType();
        if (typeMirror.getKind().isPrimitive()) {
            return element.asType().getKind().ordinal();
        }
        if (typeMirror instanceof DeclaredType && (typeMirror.toString().startsWith(ARRAY_LIST) || typeMirror.toString().startsWith("java.util.List"))) {
            DeclaredType type = (DeclaredType)typeMirror;
            List<? extends TypeMirror> argumentTypes = type.getTypeArguments();
            if (argumentTypes != null && !argumentTypes.isEmpty()) {
                TypeMirror argumentTp = argumentTypes.get(0);
                if (argumentTp.toString().equals(STRING)) {
                    return TypeKind.STRING_LIST.ordinal();
                }
                if (this.mTypes.isSubtype(argumentTp, this.mTypeParcelableType)) {
                    return TypeKind.PARCELABLE_LIST.ordinal();
                }
            } else {
                return TypeKind.OBJECT.ordinal();
            }
        }
        this.mLogs.printMessage(Diagnostic.Kind.NOTE, "find type--[" + typeMirror.toString() + "] ");
        switch (typeMirror.toString()) {
            case "java.lang.Byte": {
                return TypeKind.BYTE.ordinal();
            }
            case "java.lang.Short": {
                return TypeKind.SHORT.ordinal();
            }
            case "java.lang.Integer": {
                return TypeKind.INT.ordinal();
            }
            case "java.lang.Long": {
                return TypeKind.LONG.ordinal();
            }
            case "java.lang.Float": {
                return TypeKind.FLOAT.ordinal();
            }
            case "java.lang.Double": {
                return TypeKind.DOUBLE.ordinal();
            }
            case "java.lang.Boolean": {
                return TypeKind.BOOLEAN.ordinal();
            }
            case "java.lang.String": {
                return TypeKind.STRING.ordinal();
            }
            case "boolean[]": {
                return TypeKind.BOOLEAN_ARRAY.ordinal();
            }
            case "int[]": {
                return TypeKind.INT_ARRAY.ordinal();
            }
            case "long[]": {
                return TypeKind.LONG_ARRAY.ordinal();
            }
            case "char[]": {
                return TypeKind.CHAR_ARRAY.ordinal();
            }
            case "float[]": {
                return TypeKind.FLOAT_ARRAY.ordinal();
            }
            case "double[]": {
                return TypeKind.DOUBLE_ARRAY.ordinal();
            }
            case "java.lang.String[]": {
                return TypeKind.STRING_ARRAY.ordinal();
            }
        }
        if (this.mTypes.isSubtype(typeMirror, this.mTypeParcelableType)) {
            return TypeKind.PARCELABLE.ordinal();
        }
        if (this.mTypes.isSubtype(typeMirror, this.mTypeSerializableType)) {
            return TypeKind.SERIALIZABLE.ordinal();
        }
        return TypeKind.OBJECT.ordinal();
    }
}

