/*
 * Decompiled with CFR 0.152.
 */
package android.dev.compiler;

import android.dev.annotation.AppDeckNail;
import android.dev.compiler.BaseProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class AppLoaderProcessor
extends BaseProcessor {
    private static final String ASSET_PATH = "assets/app_deck/";

    @Override
    protected boolean processing(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        this.log(">>>>>>>>>>>>>>start generate AppDeck");
        ArrayList<String> list = new ArrayList<String>();
        TypeMirror typeAppDeck = this.mElements.getTypeElement("android.dev.base.components.AppDeck").asType();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(AppDeckNail.class)) {
            TypeMirror tm = element.asType();
            String name = tm.toString();
            if (list.contains(name)) continue;
            TypeElement typeElement = (TypeElement)element;
            if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("class [" + tm.toString() + "] used @AppDeckNail,must be public class");
                return false;
            }
            if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                this.error("class [" + tm.toString() + "] used @AppDeckNail,must not be abstract class");
                return false;
            }
            boolean hasPublicNoParameterConstructor = false;
            for (Element element2 : typeElement.getEnclosedElements()) {
                ExecutableElement constructorElement;
                if (element2.getKind() != ElementKind.CONSTRUCTOR || (constructorElement = (ExecutableElement)element2).getParameters().size() != 0 || !constructorElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                hasPublicNoParameterConstructor = true;
            }
            if (!hasPublicNoParameterConstructor) {
                this.error("class [" + tm.toString() + "] annotated @AppDeckNail ,must provide an public empty default constructor");
                return false;
            }
            if (!this.mType.isSubtype(tm, typeAppDeck)) continue;
            list.add(name);
            String path = ASSET_PATH + name;
            try {
                FileObject fileObject = this.mFiler.createResource(StandardLocation.CLASS_OUTPUT, "", path, new Element[0]);
                fileObject.openWriter().close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        list.clear();
        this.log(">>>>>>>>>>>>>>generate AppDeckNail end");
        return true;
    }

    @Override
    protected void putSupportAnnotations(Set<String> types) {
        types.add(AppDeckNail.class.getName());
    }
}

