package android.dangngocduc.toolbarios;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.LinearLayoutCompat;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
/**
 * Created by DANG NGOC DUC on 6/13/2016.
 */
public class IOSToolBar extends Toolbar {
    public IOSToolBar(Context context) {
        super(context);
        init(context);
    }

    public IOSToolBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public IOSToolBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }




    protected ImageView mLeftButton, mRightButton;
    protected TextView mLeftTitle, mRightTitle, mCenterTitle;

    public void init(Context context) {

        LinearLayout l=(LinearLayout)LinearLayout.inflate(context,R.layout.toolbar_ios,null);
        l.setOrientation(LinearLayout.HORIZONTAL);
        l.setWeightSum(1);


        mLeftButton = (ImageView)l.getChildAt(0);
        mLeftTitle = (TextView) l.getChildAt(1);
        mCenterTitle = (TextView) l.getChildAt(2);
        mRightTitle = (TextView) l.getChildAt(3);
        mRightButton = (ImageView) l.getChildAt(4);
        this.addView(l,new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        setElevation(getResources().getDimensionPixelOffset(R.dimen.elevation));
       setContentInsetsRelative(0,0);
    }

    /**
     * @param res the resource identifier of the drawable
     */
    public void setImageResourceLeft(int res) {
        mLeftButton.setImageResource(res);
    }

    /**
     * @param res the resource identifier of the drawable
     */
    public void setImageResourceRight(int res) {
        mRightButton.setImageResource(res);
    }


    public ImageView getmLeftButton() {
        return mLeftButton;
    }

    public ImageView getmRightButton() {
        return mRightButton;
    }


    public TextView getmLeftTitle() {
        return mLeftTitle;
    }

    public TextView getmRightTitle() {
        return mRightTitle;
    }

    public TextView getmCenterTitle() {
        return mCenterTitle;
    }


}
