package android.baseframework.core.repository.config

import android.baseframework.core.config.Api
import com.google.gson.GsonBuilder
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory


object RetrofitManager {

    fun buildBaseRetrofit(): Retrofit {
        val retrofitBuilder = Retrofit.Builder()
                .client(OkHttpClientManager.getInstance().createOkHttpClient())
                .addConverterFactory(GsonConverterFactory.create())
        retrofitBuilder.baseUrl(Api.SERVER_URL)
        return retrofitBuilder.build()
    }
}